<?php
// Cargar WordPress
require_once(__DIR__ . '/../../../wordpress/wp-load.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Escuela Profesional de Obstetricia - Facultad de Ciencias de la Salud - UNSM">
    <meta name="keywords" content="UNSM, Obstetricia, Ciencias de la Salud, Universidad San Martin, Salud Materna">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#8B1538">

    <title>Escuela de Obstetricia - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Ciencias de la Salud -->
    <link rel="stylesheet" href="../css/styleSalud.css">
    <!-- Stylesheet Obstetricia -->
    <link rel="stylesheet" href="css/styleObst.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en Facebook" aria-label="Pagina oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm" target="_blank" rel="noopener noreferrer" title="Siguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Telefono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la pagina principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martin" width="auto" height="70">
                </a>
            </div>

            <!-- Boton Hamburguesa para movil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menu de navegacion" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegacion principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menu Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Mision y Vision</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Academico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menu Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Academico</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../admision/indexAdmin.php">ADMISION</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menu Facultades">
                            <li class="has-submenu">
                                <a href="../../ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../ciencias agrarias/agronomia/indexAgro.php">Agronomia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../indexSalud.php" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="indexObst.php">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingenieria Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Agroindustrial">
                                    <li><a href="#ing-agroindustrial">Ingenieria Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingenieria Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Civil y Arquitectura">
                                    <li><a href="#arquitectura">Arquitectura</a></li>
                                    <li><a href="#ingenieria-civil-carrera">Ingenieria Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingenieria de Sistemas e Informatica</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria de Sistemas">
                                    <li><a href="#ing-sistemas">Ingenieria de Sistemas e Informatica</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ecologia" aria-haspopup="true" aria-expanded="false">Ecologia</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecologia">
                                    <li><a href="#ing-ambiental">Ingenieria Ambiental</a></li>
                                    <li><a href="#ing-sanitaria">Ingenieria Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Politicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="#enfermeria">Enfermeria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#educacion" aria-haspopup="true" aria-expanded="false">Educacion y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educacion">
                                    <li><a href="#educacion-inicial">Educacion Inicial</a></li>
                                    <li><a href="#educacion-primaria">Educacion Primaria</a></li>
                                    <li><a href="#educacion-secundaria">Educacion Secundaria</a></li>
                                    <li><a href="#psicologia">Psicologia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Economicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Economicas">
                                    <li><a href="#administracion">Administracion</a></li>
                                    <li><a href="#economia">Economia</a></li>
                                    <li><a href="#contabilidad">Contabilidad</a></li>
                                    <li><a href="#turismo">Turismo</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li><a href="../../../#transparencia">TRANSPARENCIA</a></li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Peru">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Peru">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Obstetricia -->
    <section class="obst-banner">
        <div class="banner-image">
            <img src="../imagenes/doctor-using-stethoscope-examining-pregnant-woman.jpg" alt="Profesional de obstetricia atendiendo paciente">
        </div>
        <div class="banner-overlay"></div>
        <div class="banner-content-wrapper">
            <div class="banner-header">
                <div class="banner-logo">
                    <img src="../../../imagenes/Escudos de Facultades — UNSM/FCS-UNSM-2021.png" alt="Logo Facultad de Ciencias de la Salud" width="80" height="80">
                </div>
                <div class="banner-title-section">
                    <h1>ESCUELA DE OBSTETRICIA</h1>
                    <p class="banner-breadcrumb">Facultad de Ciencias de la Salud</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Seccion Informacion con Tabs -->
    <section class="info-section">
        <div class="info-container">
            <div class="info-grid">
                <div class="info-main">
                    <div class="tabs-wrapper">
                        <div class="tabs-buttons">
                            <button class="tab-button active" data-tab="escuela">
                                <span class="tab-icon-label">NUESTRA</span>
                                <span class="tab-text-label">ESCUELA</span>
                            </button>
                            <button class="tab-button" data-tab="resena">
                                <span class="tab-icon-label">NUESTRA</span>
                                <span class="tab-text-label">RESENA HISTORICA</span>
                            </button>
                        </div>

                        <div class="tabs-content">
                            <div class="tab-content active" id="escuela">
                                <p>En el Peru, Obstetricia es una carrera medica segun Ley N° 23346 de nivel universitario, la Universidad Nacional de San Martin tiene emblematicamente la carrera de Obstetricia como una de las pioneras contribuyendo al desarrollo, la formacion de profesionales de la salud con una base cientifica, humanistica y con sensibilidad hacia los problemas de salud y sociales, relacionados a la salud sexual y reproductiva de la poblacion peruana en especial la mujer gestante, recien nacido y familia.</p>

                                <p>La Obstetricia es la ciencia de la salud y la profesion que se encarga del cuidado de la salud sexual y reproductiva de la mujer, familia y comunidad a lo largo del ciclo vital de las personas, desde la vida intrauterina, infancia, adolescencia hasta la edad del adulto y adulto mayor. La salud sexual y reproductiva de las personas, esta en estrecha relacion con su entorno familiar, social y su medio ambiente, para alcanzar y conservar se requiere de acciones de atencion integral especificas, y diferenciadas tanto de promocion, prevencion, recuperacion y rehabilitacion en cada una de estas etapas, debido a que las necesidades en el area sexual y reproductiva son cambiantes segun las etapas del ciclo de vida, de acuerdo con lo establecido en la estrategia sanitaria de salud sexual y reproductiva del Ministerio de Salud (MINSA).</p>

                                <p>Nuestra escuela profesional busca la mejora continua de la calidad universitaria para que vaya implementando mejoras educativas en beneficio de nuestros estudiantes, y asi contribuir a la calidad de la salud y desarrollo de la sociedad.</p>

                                <p>La Escuela Profesional de Obstetricia cuenta en la actualidad con 24 docentes nombrados y 8 docentes contratados, quienes desarrollan actividades academicas y administrativas integrando las diferentes Comisiones de Trabajo de la Facultad y la Escuela Profesional de Obstetricia, realizan actividades de investigacion integrando los Grupos de Investigacion de la Universidad y actividades de Responsabilidad Social con participacion en los proyectos y campanas dirigidas a la comunidad.</p>

                                <p>Cuenta con la oficina de Direccion, Secretaria de la Escuela Profesional de Obstetricia, una Sala para docentes provista con mobiliario y equipos de computo para permitir la permanencia de docentes a tiempo completo y tiempo parcial. Del mismo modo cuenta con aulas y ambientes de laboratorios implementados para la ensenanza con enfoque humanistico, equipados con simuladores y maquetas donde se desarrollan las practicas clinicas, previas a las que se realizan con pacientes en el marco del respeto al derecho de los pacientes.</p>

                                <p>Nuestra escuela disciplina a nuestros alumnos en proporcionar los conocimientos adecuados para la prevencion de las enfermedades, la promocion de la salud y el bienestar tanto del individuo como de la colectividad. Se dice que las ciencias de la salud son interdisciplinarias por el hecho de entrelazar o combinar varias ciencias para el estudio de un mismo caso clinico desconocido o para profundizar el estudio de una forma mas especializada.</p>

                                <p>Las investigaciones de esta ciencia estan basadas en las ciencias puras como la Biologia, la Quimica y la Fisica, aunque tambien en Ciencias Sociales, como la sociologia medica, la psicologia, etc.</p>
                            </div>
                            <div class="tab-content" id="resena">
                                <h3>RESENA HISTORICA</h3>
                                <p>La Carrera Profesional Universitaria de Obstetricia fue una de las cuatro primeras carreras creadas en la Universidad Nacional de San Martin y la region San Martin.</p>

                                <p>Nace como programa academico en 1979, decision que fue ratificada el 29 de noviembre de 1983 con Resolucion N° 3868-83-CONAI, contando con la designacion del Doctor Rene Cervantes Begazo profesor principal del Departamento de Obstetricia y Ginecologia de la Universidad Nacional Mayor de San Marcos, como presidente de la comision asesora para su implementacion.</p>

                                <p>En el ano 1,982, inicia su funcionamiento con 60 ingresantes. La demanda de la carrera de Obstetricia dio origen a la creacion de la Facultad del mismo nombre y posteriormente, mediante Resolucion Rectoral N° 462-94-UNSM/R del 09 de diciembre de 1994 se crea la Carrera de Enfermeria y Medicina Humana que junto a la Carrera de Obstetricia pasan a integrar la Facultad de Ciencias de la Salud con la Resolucion N° 434-96-UNSM/R.</p>

                                <p>En el ano 2012, mediante Resolucion Rectoral N° 003-2012-UNSM/R de fecha 07 de mayo la Carrera Profesional de Medicina Humana conforma la Facultad del mismo nombre.</p>

                                <p>La carrera profesional de Obstetricia depende funcional y administrativamente de la decanatura y el consejo de facultad y para su normal funcionamiento cuenta actualmente con el concurso de 30 docentes ordinarios, 02 jefes de practica y 18 docentes de apoyo provenientes de otras facultades y departamentos.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar con Proximos Eventos -->
                <aside class="info-sidebar">
                    <div class="eventos-widget">
                        <h3>Proximos Eventos</h3>
                        <div class="eventos-container">
                            <div class="evento-item">
                                <span class="evento-icon">&#9654;</span>
                                <span class="evento-text">Ahora</span>
                            </div>
                            <p class="no-events">No hay nuevos eventos.</p>
                            <div class="eventos-actions">
                                <a href="#" class="btn-eventos">Ver Calendario &#9656;</a>
                            </div>
                        </div>
                    </div>

                    <!-- Widget Facebook Obstetricia -->
                    <div class="facebook-widget">
                        <h3>Obstetricia UNSM</h3>
                        <div class="fb-page"
                            data-href="https://www.facebook.com/unsmperu"
                            data-tabs="timeline"
                            data-width="280"
                            data-height="300"
                            data-small-header="true"
                            data-adapt-container-width="true"
                            data-hide-cover="false"
                            data-show-facepile="true">
                            <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                                <a href="https://www.facebook.com/unsmperu">Obstetricia UNSM</a>
                            </blockquote>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </section>

    <!-- Seccion Carrera Profesional -->
    <section class="carrera-section">
        <div class="carrera-container">
            <div class="carrera-header">
                <h2>CARRERA PROFESIONAL: OBSTETRICIA</h2>
            </div>

            <div class="carrera-grid">
                <!-- Menu lateral izquierdo -->
                <aside class="carrera-sidebar">
                    <nav class="carrera-menu">
                        <button class="carrera-menu-item active" data-carrera-tab="mision-vision">
                            <span class="menu-icon">&#9733;</span>
                            <span class="menu-text">MISION - VISION</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="objetivos">
                            <span class="menu-icon">&#10003;</span>
                            <span class="menu-text">OBJETIVOS ACADEMICOS</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="autoridades">
                            <span class="menu-icon">&#128100;</span>
                            <span class="menu-text">AUTORIDADES</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="perfil">
                            <span class="menu-icon">&#128196;</span>
                            <span class="menu-text">PERFIL ACADEMICO</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="proposito">
                            <span class="menu-icon">&#127919;</span>
                            <span class="menu-text">PROPOSITO DEL PROGRAMA</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="ambito">
                            <span class="menu-icon">&#127758;</span>
                            <span class="menu-text">AMBITO DE TRABAJO</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="especializacion">
                            <span class="menu-icon">&#128218;</span>
                            <span class="menu-text">AREA DE ESPECIALIZACION</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="requisitos">
                            <span class="menu-icon">&#127891;</span>
                            <span class="menu-text">REQUISITOS EGRESADOS, GRADOS Y TITULOS</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="duracion">
                            <span class="menu-icon">&#128197;</span>
                            <span class="menu-text">DURACION DE LA CARRERA</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="documentos">
                            <span class="menu-icon">&#128195;</span>
                            <span class="menu-text">DOCUMENTOS DE GESTION</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="consejo">
                            <span class="menu-icon">&#128101;</span>
                            <span class="menu-text">CONSEJO DE FACULTAD</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="comisiones">
                            <span class="menu-icon">&#128203;</span>
                            <span class="menu-text">COMISIONES</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="docentes">
                            <span class="menu-icon">&#128104;</span>
                            <span class="menu-text">DOCENTES</span>
                        </button>
                        <button class="carrera-menu-item" data-carrera-tab="galeria">
                            <span class="menu-icon">&#128247;</span>
                            <span class="menu-text">GALERIA DE ACTIVIDADES</span>
                        </button>
                    </nav>
                </aside>

                <!-- Contenido central -->
                <div class="carrera-content">
                    <div class="carrera-tab-content active" id="mision-vision">
                        <h3>MISION</h3>
                        <blockquote class="mision-quote">
                            "Formar profesionales en Obstetricia con enfoque integral, humanistico, cientifico y tecnologico para brindar atencion a la mujer, familia y comunidad, con enfasis en salud sexual y reproductiva en todos los niveles resolutivos; participando activamente en la transformacion y desarrollo sostenible de la region y el pais, fomentando la excelencia academica, la etica profesional, responsabilidad social y mejora continua"
                        </blockquote>

                        <h3>VISION</h3>
                        <blockquote class="vision-quote">
                            "Ser reconocidos a nivel nacional e internacional por la excelencia en la formacion de Obstetras, con principios eticos, cientificos, humanisticos y compromiso social; integrando la docencia, investigacion, innovacion y liderazgo en salud sexual y reproductiva para impactar en el desarrollo social y cultural; promoviendo un sistema de salud inclusivo y de calidad"
                        </blockquote>

                        <p class="resolucion-info">Resolucion N° 039-2025-UNSM/FCS/CF</p>
                    </div>

                    <div class="carrera-tab-content" id="objetivos">
                        <h3>OBJETIVOS ACADEMICOS</h3>
                        <ul class="objetivos-list">
                            <li>Formar profesionales obstetras con solidos conocimientos cientificos, tecnologicos y humanisticos.</li>
                            <li>Desarrollar competencias para la atencion integral de la salud sexual y reproductiva.</li>
                            <li>Promover la investigacion cientifica en el campo de la obstetricia.</li>
                            <li>Fomentar valores eticos y responsabilidad social en el ejercicio profesional.</li>
                            <li>Contribuir al desarrollo de la salud publica regional y nacional.</li>
                        </ul>
                    </div>

                    <div class="carrera-tab-content" id="autoridades">
                        <h3>AUTORIDADES</h3>
                        <p>Informacion de autoridades disponible proximamente.</p>
                    </div>

                    <div class="carrera-tab-content" id="perfil">
                        <h3>PERFIL ACADEMICO</h3>
                        <p>El egresado de la Escuela Profesional de Obstetricia esta capacitado para:</p>
                        <ul class="objetivos-list">
                            <li>Brindar atencion integral en salud sexual y reproductiva.</li>
                            <li>Realizar control prenatal y atencion del parto.</li>
                            <li>Desarrollar actividades de promocion y prevencion de la salud.</li>
                            <li>Participar en programas de planificacion familiar.</li>
                            <li>Realizar investigacion cientifica en su campo profesional.</li>
                        </ul>
                    </div>

                    <div class="carrera-tab-content" id="proposito">
                        <h3>PROPOSITO DEL PROGRAMA</h3>
                        <p>Formar profesionales obstetras competentes y comprometidos con la salud de la mujer, la familia y la comunidad.</p>
                    </div>

                    <div class="carrera-tab-content" id="ambito">
                        <h3>AMBITO DE TRABAJO</h3>
                        <ul class="objetivos-list">
                            <li>Hospitales y clinicas publicas y privadas.</li>
                            <li>Centros y puestos de salud.</li>
                            <li>Consultorios particulares.</li>
                            <li>Instituciones educativas.</li>
                            <li>Organizaciones no gubernamentales de salud.</li>
                            <li>Instituciones de investigacion.</li>
                        </ul>
                    </div>

                    <div class="carrera-tab-content" id="especializacion">
                        <h3>AREA DE ESPECIALIZACION</h3>
                        <ul class="objetivos-list">
                            <li>Salud Sexual y Reproductiva</li>
                            <li>Obstetricia de Alto Riesgo</li>
                            <li>Neonatologia</li>
                            <li>Planificacion Familiar</li>
                            <li>Salud Publica</li>
                        </ul>
                    </div>

                    <div class="carrera-tab-content" id="requisitos">
                        <h3>REQUISITOS EGRESADOS, GRADOS Y TITULOS</h3>
                        <p><strong>Grado Academico:</strong> Bachiller en Obstetricia</p>
                        <p><strong>Titulo Profesional:</strong> Licenciado(a) en Obstetricia</p>
                    </div>

                    <div class="carrera-tab-content" id="duracion">
                        <h3>DURACION DE LA CARRERA</h3>
                        <p><strong>Duracion:</strong> 5 anos (10 semestres academicos)</p>
                        <p><strong>Modalidad:</strong> Presencial</p>
                    </div>

                    <div class="carrera-tab-content" id="documentos">
                        <h3>DOCUMENTOS DE GESTION</h3>
                        <p>Documentos disponibles proximamente.</p>
                    </div>

                    <div class="carrera-tab-content" id="consejo">
                        <h3>CONSEJO DE FACULTAD</h3>
                        <p>Informacion del Consejo de Facultad disponible proximamente.</p>
                    </div>

                    <div class="carrera-tab-content" id="comisiones">
                        <h3>COMISIONES</h3>
                        <p>Informacion de comisiones disponible proximamente.</p>
                    </div>

                    <div class="carrera-tab-content" id="docentes">
                        <h3>DOCENTES</h3>
                        <p>Listado de docentes disponible proximamente.</p>
                    </div>

                    <div class="carrera-tab-content" id="galeria">
                        <h3>GALERIA DE ACTIVIDADES</h3>
                        <p>Galeria de fotos disponible proximamente.</p>
                    </div>
                </div>

                <!-- Sidebar derecho con Contacto y Facebook -->
                <aside class="carrera-right-sidebar">
                    <div class="contacto-widget">
                        <h3>Contacto</h3>
                        <div class="contacto-icons">
                            <a href="mailto:obstetricia@unsm.edu.pe" class="contacto-icon-link" title="Email">
                                <span class="contact-circle email">&#9993;</span>
                            </a>
                            <a href="https://wa.me/51942000000" class="contacto-icon-link" title="WhatsApp">
                                <span class="contact-circle whatsapp">&#128172;</span>
                            </a>
                        </div>
                    </div>

                    <div class="facebook-sidebar-widget">
                        <div class="fb-page"
                            data-href="https://www.facebook.com/unsmperu"
                            data-tabs="timeline"
                            data-width="280"
                            data-height="350"
                            data-small-header="true"
                            data-adapt-container-width="true"
                            data-hide-cover="false"
                            data-show-facepile="true">
                            <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                                <a href="https://www.facebook.com/unsmperu">Obstetricia UNSM</a>
                            </blockquote>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </section>

    <!-- Seccion Ultimas Noticias -->
    <section class="noticias-section">
        <div class="noticias-container">
            <h2>Ultimas Noticias</h2>
            <div class="noticias-grid">
                <?php
                // Obtener ultimas noticias desde WordPress
                $noticias_args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => 3,
                    'orderby'        => 'date',
                    'order'          => 'DESC',
                    'post_status'    => 'publish'
                );

                $noticias_query = new WP_Query($noticias_args);

                if ($noticias_query->have_posts()) :
                    while ($noticias_query->have_posts()) : $noticias_query->the_post();
                ?>
                    <article class="noticia-card">
                        <div class="noticia-image">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('medium', array('alt' => get_the_title(), 'loading' => 'lazy')); ?>
                            <?php else : ?>
                                <img src="../imagenes/young-cheerful-doctor-holding-ultrasound-scan-baby.jpg" alt="<?php echo esc_attr(get_the_title()); ?>" loading="lazy">
                            <?php endif; ?>
                            <div class="noticia-overlay">
                                <a href="<?php the_permalink(); ?>" class="btn-read-more">Read more +</a>
                            </div>
                        </div>
                        <div class="noticia-content">
                            <span class="noticia-date"><?php echo get_the_date('d F, Y'); ?> Por admin en <strong>Noticias UNSM</strong></span>
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        </div>
                    </article>
                <?php
                    endwhile;
                    wp_reset_postdata();
                else :
                ?>
                    <article class="noticia-card">
                        <div class="noticia-image">
                            <img src="../imagenes/young-cheerful-doctor-holding-ultrasound-scan-baby.jpg" alt="Noticia obstetricia" loading="lazy">
                            <div class="noticia-overlay">
                                <a href="#" class="btn-read-more">Read more +</a>
                            </div>
                        </div>
                        <div class="noticia-content">
                            <span class="noticia-date">27 Enero, 2025 Por admin en <strong>Noticias UNSM</strong></span>
                            <h3><a href="#">Aviso de venta publica de semovientes convocado por la Comision de Recepcion y Venta de Ganado de la UNSM</a></h3>
                        </div>
                    </article>
                    <article class="noticia-card">
                        <div class="noticia-image">
                            <img src="../imagenes/doctor-using-stethoscope-examining-pregnant-woman.jpg" alt="Noticia obstetricia" loading="lazy">
                            <div class="noticia-overlay">
                                <a href="#" class="btn-read-more">Read more +</a>
                            </div>
                        </div>
                        <div class="noticia-content">
                            <span class="noticia-date">20 Diciembre, 2024 Por admin en <strong>Noticias UNSM</strong></span>
                            <h3><a href="#">UNSM suscribio convenio originario para promover la donacion voluntaria de sangre en la region</a></h3>
                        </div>
                    </article>
                    <article class="noticia-card">
                        <div class="noticia-image">
                            <img src="../imagenes/young-cheerful-doctor-holding-ultrasound-scan-baby.jpg" alt="Ceremonia graduacion" loading="lazy">
                            <div class="noticia-overlay">
                                <a href="#" class="btn-read-more">Read more +</a>
                            </div>
                        </div>
                        <div class="noticia-content">
                            <span class="noticia-date">15 Diciembre, 2024 Por admin en <strong>Noticias UNSM</strong></span>
                            <h3><a href="#">UNSM realizo ceremonia de colacion de grados academicos y titulos profesionales por su 46° aniversario</a></h3>
                        </div>
                    </article>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autonomo y de caracter estatal, comprometido con la formacion de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martin - Peru</p>
                    <p>Central Telefonica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rapidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../admision/indexAdmin.php">Admision</a></li>
                    <li><a href="../../../index.php#facultades">Facultades</a></li>
                    <li><a href="../../../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../../../index.php#investigacion">Investigacion</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../../index.php#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../../index.php#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../../index.php#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../../index.php#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../../index.php#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martin - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martin. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Siguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>

    <script src="../../../js/script.js" defer></script>
    <script src="js/scriptObst.js" defer></script>
</body>
</html>
